DROP TABLE IF EXISTS `site_users`;
CREATE TABLE `site_users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_key` varchar(32) DEFAULT NULL,
  `user_key_date` int(11) NOT NULL,
  `user_first_name` varchar(200) DEFAULT NULL,
  `user_last_name` varchar(200) DEFAULT NULL,
  `user_login` varchar(200) NOT NULL,
  `user_password` varchar(200) DEFAULT NULL,
  `user_email` varchar(200) DEFAULT NULL,
  `user_level` int(1) NOT NULL DEFAULT '0',
  `user_protect_delete` int(1) NOT NULL DEFAULT '0',
  `user_protect_edit` int(1) NOT NULL DEFAULT '0',
  `user_log_last_login` int(11) NOT NULL DEFAULT '0',
  `user_log_last_ip` varchar(200) DEFAULT NULL,
  `user_log_create` int(11) NOT NULL DEFAULT '0',
  `user_log_tries` int(2) NOT NULL DEFAULT '0',
  `user_log_image_text` varchar(50) DEFAULT NULL,
  `user_log_status` int(1) NOT NULL DEFAULT '0',
  `user_contact_phone3` varchar(20) DEFAULT NULL,
  `user_contact_zip` varchar(20) DEFAULT NULL,
  `user_perm` text NOT NULL,
  `user_perm2` text NOT NULL,
  `user_groups` text NOT NULL,
  `user_status` int(1) NOT NULL,
  `user_block` int(11) NOT NULL,
  PRIMARY KEY (`user_id`),
  KEY `user_email` (`user_email`),
  KEY `user_log_status` (`user_log_status`),
  FULLTEXT KEY `user_login` (`user_login`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_users_acl`;
CREATE TABLE `site_users_acl` (
  `acl_id` int(11) NOT NULL AUTO_INCREMENT,
  `acl_type` int(1) NOT NULL,
  `acl_user` int(11) NOT NULL,
  `acl_group` int(11) NOT NULL,
  `acl_code` varchar(255) NOT NULL,
  `acl_module` varchar(50) NOT NULL,
  `acl_mod_id` int(11) NOT NULL,
  PRIMARY KEY (`acl_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_users_dashboard_notify`;
CREATE TABLE `site_users_dashboard_notify` (
  `notify_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `notify_date` varchar(255) NOT NULL,
  PRIMARY KEY (`notify_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_users_groups`;
CREATE TABLE `site_users_groups` (
  `group_id` int(11) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) NOT NULL,
  `group_type` int(11) NOT NULL,
  `group_status` int(11) NOT NULL,
  `group_system` int(1) NOT NULL,
  `group_superadmin` int(1) NOT NULL,
  `group_viewonly` int(1) NOT NULL,
  PRIMARY KEY (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_users_log`;
CREATE TABLE `site_users_log` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT,
  `log_date` int(11) NOT NULL,
  `log_user` int(11) NOT NULL,
  `log_url` text NOT NULL,
  `log_url_referer` text NOT NULL,
  `log_ip` varchar(50) NOT NULL,
  `log_vars_post` longtext NOT NULL,
  `log_vars_get` longtext NOT NULL,
  `log_vars_files` longtext NOT NULL,
  PRIMARY KEY (`log_id`),
  KEY `log_date` (`log_date`),
  KEY `log_user` (`log_user`),
  KEY `log_date_2` (`log_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_users_logins`;
CREATE TABLE `site_users_logins` (
  `login_id` int(11) NOT NULL AUTO_INCREMENT,
  `login_user` varchar(100) NOT NULL,
  `login_date` int(11) NOT NULL,
  `login_uid` int(11) NOT NULL,
  `log_ip` varchar(50) NOT NULL,
  `log_domain` varchar(255) NOT NULL,
  `log_agent` varchar(255) NOT NULL,
  PRIMARY KEY (`login_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



INSERT INTO `site_users_groups` (`group_id`, `group_name`, `group_type`, `group_status`, `group_system`, `group_superadmin`) VALUES
(1,	'Super Admins',	0,	0,	1,	1);

INSERT INTO `site_users_groups` (`group_name`, `group_type`, `group_status`, `group_system`, `group_superadmin` , `group_viewonly`) VALUES
('View Only',	0,	0,	1,	1 , 1);


UPDATE site_users SET user_status=1, user_groups=1;
